// JScript source code
function reLayout(strURL)
{
	// If the numdays div is visible, resize the content iframe to end 
	// at the left edge of numdays div.
	var sShowNumDays = extractParam(strURL, "ShowCounter");
	if ( sShowNumDays.toLowerCase() == "yes" )
	{
		var strDays = extractParam(strURL, "NumDays");
		if (parseInt(strDays) < 0)
		{
			strDays = "0";
		}
		NumDays.innerText = strDays;
		divPromo.style.display = "";
		tdPromo.style.display = "";
	}
	else
	{
		divPromo.style.display = "none";
		tdPromo.style.display = "none";
	}
}

function ShowBanner(strShow)
{
	var bannerTop = document.getElementById("bannerTop");
	var bannerCenter = document.getElementById("bannerCenter");
	var bannerBottom = document.getElementById("bannerBottom");
	if ((bannerTop != null) && (bannerCenter != null) && (bannerBottom != null))
	{
		if ( strShow.toLowerCase() == "no" )
		{
			bannerTop.style.display = "none";
			bannerCenter.style.display = "none";
			bannerBottom.style.display = "none";
		}
		else 
		{
			bannerTop.style.display = "inline";
			bannerCenter.style.display = "inline";
			bannerBottom.style.display = "inline";
		}
	}
}

function SetActivationCodeElement()
{
	var strActCode = getParamVal("activationcode");
	var oTxt = document.getElementById("txtActivationCode");
	
	if (strActCode != null && oTxt != null)
		oTxt.value = strActCode.toUpperCase();
}

function getParamString()
{
  var sParamString = "";
	var sQueryVar = location.search;
	var nIndex = sQueryVar.indexOf("?");
	if ( nIndex >= 0 )
	{
	  sParamString = sQueryVar.substr(nIndex);
  }	
  
  return sParamString;
}

function getParamVal(paramName)
{
	var sQueryVar = location.search.toLowerCase();
	return extractParam(sQueryVar, paramName);
}	

function extractParam(sQueryVar, paramName)
{
	if (sQueryVar == null || paramName == null)
	  return "";

	var nIndex = sQueryVar.indexOf("?");
	if (nIndex >= 0)
		sQueryVar = sQueryVar.substr(nIndex + 1);

	paramName = paramName.toLowerCase();

	var asParams = sQueryVar.split("&");
	var i;

	for (i in asParams)
	{
		var pair = asParams[i].split("=");
		if (pair.length == 2)
		{
			if (pair[0].toLowerCase() == paramName)
			{
				return pair[1];
			}
		}
	}

	return "";
}

function EnableContinue(bEnable)
{
	var oBtn = document.getElementById("btnContinue");
	if (oBtn != null)
	{
		oBtn.disabled = (bEnable == false);
	}
}

function ExpandRelativeURL(sPage)
{
	var sPath = location.pathname;
	var lastbkslsh = sPath.lastIndexOf("\\");
	if (lastbkslsh < 0)
	{
		lastbkslsh = sPath.lastIndexOf("/");
	}
	if (lastbkslsh < 0)
	{
		lastbkslsh = 0;
	}
	sPath = sPath.substr(0, lastbkslsh + 1);
	var sReturn = location.protocol + "//" + location.host + sPath + sPage;
	return sReturn;
}

function ValidateSerial(sSerial)
{
	if (sSerial != null && sSerial.match(/^\s*[a-zA-Z]{2}\d{2}[a-zA-Z]{3}-?\d{7}-?[a-zA-Z]{3}(?:\*\d{6})?\s*$/) != null)
	{
		return true;
	}
	return false;
}

function ValidateActCode(sCode)
{
	if (sCode != null && sCode.match(/^\s*(?:[a-fA-F0-9]{4}-?){5}\s*$/) != null)
	{
		return true;
	}
	
	return false;
}

function FormatSerial(sCode)
{
	if (sCode != null && sCode.length >= 17 && sCode.indexOf("-") == -1)
	{
		var sNewCode = sCode.substr(0,7) + "-" + sCode.substr(7,7) + "-" + sCode.substr(14);
		sNewCode = sNewCode.toUpperCase();
		return sNewCode;
	}
	else
	{
		return sCode;
	}
}

function FormatActivationCode(sCode)
{
	if (sCode != null && sCode.length == 20 && sCode.indexOf("-") == -1)
	{
		var sNewCode = sCode.substr(0,4) + "-" + sCode.substr(4,4) + "-" + 
									 sCode.substr(8,4) + "-" + sCode.substr(12,4) + "-" + sCode.substr(16,4);
		sNewCode = sNewCode.toUpperCase();
		return sNewCode;
	}
	else
	{
		return sCode;
	}
}


function regChangeLaunchButtonTitle()
{
	var btnClose = document.getElementById("btnClose");
	if ( btnClose != null )
	{
		btnClose.style.display = "inline";
		
		var btnLaunch = document.getElementById("btnLaunch");
		if ( btnLaunch != null )
		{
			btnLaunch.style.display = "none";
		}
	}
}